#include "MeshLoader.h"

const std::vector<Node>& MeshLoader::getVectorOfNodes() const
{
    return VectorOfNodes;
}

std::vector<FiniteElement>& MeshLoader::getVectorOfFE() 
{
    return VectorOfFE;
}

std::vector<BoundaryFiniteElement>& MeshLoader::getVectorOfBFE() 
{
    return VectorOfBFE;
}

std::vector<FiniteElement> MeshLoader::getFiniteElementsById(int id1, int id2, int id3)
{
    std::vector<FiniteElement> answer;
    auto current_iter = VectorOfFE.begin();
    auto last_iter = VectorOfFE.end();
    while (current_iter != last_iter) 
    {
        current_iter = std::find_if(current_iter, last_iter, [id1, id2, id3](FiniteElement current_element) 
            {
            return std::find(current_element.FiniteElementIdList.begin(), current_element.FiniteElementIdList.end(), id1) != current_element.FiniteElementIdList.end()
                && std::find(current_element.FiniteElementIdList.begin(), current_element.FiniteElementIdList.end(), id2) != current_element.FiniteElementIdList.end()
                && std::find(current_element.FiniteElementIdList.begin(), current_element.FiniteElementIdList.end(), id3) != current_element.FiniteElementIdList.end(); });
        if (current_iter != last_iter) 
        {
            answer.push_back(*current_iter);
            ++current_iter;
        }
    }
    return answer;
}

std::vector<FiniteElement> MeshLoader::getFiniteElementsByEdge(int x, int y) const 
{
    std::vector<FiniteElement> element{};
    auto pred = [x, y](const FiniteElement& FE)
    {
        return std::find(FE.FiniteElementIdList.begin(), FE.FiniteElementIdList.end(), x) != FE.FiniteElementIdList.end()
            && std::find(FE.FiniteElementIdList.begin(), FE.FiniteElementIdList.end(), y) != FE.FiniteElementIdList.end();
    };
    auto iter = VectorOfFE.begin();
    while (iter != VectorOfFE.end())
    {
        iter = std::find_if(iter, VectorOfFE.end(), pred);
        if (iter != VectorOfFE.end())
        {
            element.push_back(*iter);
            ++iter;
        }
    }
    return element;
}

std::vector<BoundaryFiniteElement> MeshLoader::getBoundaryFiniteElementsSTLByBoundaryId(size_t boundaryId) const 
{
    std::vector<BoundaryFiniteElement> element{};
    auto pred = [boundaryId](const BoundaryFiniteElement& BFE) 
    {
        return BFE.boundaryId == boundaryId;
    };
    auto iter = VectorOfBFE.begin();
    while (iter != VectorOfBFE.end())
    {
        iter = std::find_if(iter, VectorOfBFE.end(), pred);
        if (iter != VectorOfBFE.end())
        {
            element.push_back(*iter);
            ++iter;
        }
    }
    return element;
}

std::set<size_t> MeshLoader::getNodeSTLByBoundaryId(size_t boundaryId) const 
{
    std::set<size_t> element{};
    auto pred = [boundaryId](const BoundaryFiniteElement& BFE) 
    {
        return BFE.boundaryId == boundaryId;
    };
    auto iter = VectorOfBFE.begin();
    while (iter != VectorOfBFE.end())
    {
        iter = std::find_if(iter, VectorOfBFE.end(), pred);
        if (iter != VectorOfBFE.end())
        {
            for (const auto& node : iter->FiniteElementIdList) 
                element.insert(node);
            ++iter;
        }
    }
    return element;
}

std::vector<FiniteElement> MeshLoader::getFiniteElementsByMaterial(size_t MaterialId) const 
{
    std::vector<FiniteElement> element{};
    auto pred = [MaterialId](const FiniteElement& FE) 
    {
        return MaterialId == FE.MaterialId;
    };
    auto iter = VectorOfFE.begin();
    while (iter != VectorOfFE.end())
    {
        iter = std::find_if(iter, VectorOfFE.end(), pred);
        if (iter != VectorOfFE.end())
        {
            element.push_back(*iter);
            ++iter;
        }
    }
    return element;
}

std::vector<std::set<size_t>> MeshLoader::getNeighbourSTL() const
{
    std::vector<std::set<size_t>> vector(VectorOfNodes.size() + 1);
    for (const auto& element : VectorOfFE)
        for (const auto& id : element.FiniteElementIdList)
            for (const auto& neighbourId : element.FiniteElementIdList)
                if (id != neighbourId)
                    vector[id].insert(neighbourId);
    return vector; 
}

void MeshLoader::insertNodesInCenter()
{
    std::unordered_set <Edge, Hash> edge_set;
    for (auto& element : VectorOfFE)
    {
        std::vector<size_t> FiniteElementNodeId = element.FiniteElementIdList;
        for (int first = 0; first < 3; ++first) 
        {
            for (auto second = first + 1; second < 4; ++second) 
            {
                Edge currentEdge(FiniteElementNodeId[first], FiniteElementNodeId[second]);
                if (edge_set.insert(currentEdge).second) // check if such point already exists
                {
                    Node new_Node = getCenterNode(currentEdge);
                    currentEdge.setCenter(new_Node.NodeId);
                    VectorOfNodes.push_back(new_Node);
                    element.FiniteElementIdList.push_back(new_Node.NodeId);
                }
                else 
                {
                    element.FiniteElementIdList.push_back(currentEdge.centerNode);
                }
            }
        }
    }
    // ВЫВОД УЗЛОВ В ЭЛЕМЕНТЕ ОШИБОЧНЫЙ: ДОЛЖНО БЫТЬ РОВНО 10 УЗЛОВ В КАЖДОМ ТЕТРАЭДРЕ,
    // А У ТЕБЯ 12-13, ДА ЕЩЁ И ЧИСЛА КАКИЕ-ТО ОГРОМНЫЕ В ВЫВОДЕ
    // ЭТОТ КУСОВ ВРОДЕ ЛИШНИЙ ВООБЩЕ, ВЕДЬ В ПРЕДЫДУЩЕМ ЦИКЛЕ ПРИ ОБРАБОТКЕ ТЕТРАЭДРОВ
    // ГРАНИЧНЫЕ ПОВЕРХНОСТИ ТОЖЕ ОБРАБАТЫВАЮТСЯ (ГРАНИЧНАЯ ПОВЕРХНОСТЬ ВЕДЬ ПРИНАДЛЕЖИТ
    // КАКОМУ ТО ТЕТРАЭДРУ)
    for (auto& element : VectorOfFE)
    {
        std::vector<size_t> BoundaryFiniteElementNodeId = element.FiniteElementIdList;
        for (auto first = 0; first < 3; ++first) 
        {
            for (auto second = first + 1; second < 3; ++second) 
            {
                auto currentEdgeIter = edge_set.find({BoundaryFiniteElementNodeId[first], BoundaryFiniteElementNodeId[second]});
                if (currentEdgeIter == edge_set.end()) 
                {
                    currentEdgeIter = edge_set.find({BoundaryFiniteElementNodeId[second], BoundaryFiniteElementNodeId[first]});
                }
                element.FiniteElementIdList.push_back(currentEdgeIter->centerNode);
            }
        }
    }
}

std::array<double, 3> MeshLoader::getCenterEdge(const Edge& edge) 
{
    double centerX = ((VectorOfNodes.at(edge.nodePair.first - 1).coordinates.at(0)) +
        (VectorOfNodes.at(edge.nodePair.second - 1).coordinates.at(0))) / 2;
    double centerY = ((VectorOfNodes.at(edge.nodePair.first - 1).coordinates.at(1)) +
        (VectorOfNodes.at(edge.nodePair.second - 1).coordinates.at(1))) / 2;
    double centerZ = ((VectorOfNodes.at(edge.nodePair.first - 1).coordinates.at(2)) +
        (VectorOfNodes.at(edge.nodePair.second - 1).coordinates.at(2))) / 2;
    return {centerX, centerY, centerZ};
}

Node MeshLoader::getCenterNode(const Edge& edge) 
{
    Node new_Node(VectorOfNodes.size() + 1, getCenterEdge(edge), false); // using new Node constructor
    return new_Node;
}

void MeshLoader::PrintData()
{
    std::cout 
        << getVectorOfNodes() << std::endl
        << getVectorOfFE() << std::endl
        << getVectorOfBFE() << std::endl;
}
